<?php

namespace UltimatePostKit\Modules\PholoxSlider;

use UltimatePostKit\Base\Ultimate_Post_Kit_Module_Base;

if (!defined('ABSPATH')) exit; // Exit if accessed directly

class Module extends Ultimate_Post_Kit_Module_Base {

	public function get_name() {
		return 'pholox-slider';
	}

	public function get_widgets() {

		$widgets = [
			'Pholox_Slider',
		];

		return $widgets;
	}
	public function __construct() {

		parent::__construct();
		// add_action('admin_init', [$this, 'pholox_slide_metabox_fields']);
		// add_action('save_post', [$this, 'pholox_slide_save_metabox']);
	}

	public function pholox_slide_metabox_fields() {
		add_meta_box('upk_pholox_slide_metabox', __('Pholox Slide Additional'), [$this, 'pholox_slide_metabox_callback'], 'post', 'side', 'default');
	}
	public function pholox_slide_metabox_callback($post) {
		wp_nonce_field('pholox_slide_nonce_action', 'pholox_slide_nonce_field');
		$video_label     = esc_html__('Video Link', 'ultimate-post-kit');
		$video_link      = get_post_meta($post->ID, 'upk_pholox_slide_video_link', true);
		$display_content = <<<EOT
            <div class="upk-pholox-slide-form-group">
                <label for="upk_pholox_slide_video_link">{$video_label}</label>
                <input type="text" class="widefat" name="upk_pholox_slide_video_link" id="upk_pholox_slide_video_link" value="{$video_link}">
            </div>
EOT;
		echo $display_content;
	}

	public function pholox_slide_save_metabox($post_id) {
		if (!$this->is_secured_nonce('pholox_slide_nonce_action', 'pholox_slide_nonce_field', $post_id)) {
			return $post_id;
		}

		$video_link = isset($_POST['upk_pholox_slide_video_link']) ? $_POST['upk_pholox_slide_video_link'] : '';
		$video_link = sanitize_text_field($video_link);
		update_post_meta($post_id, 'upk_pholox_slide_video_link', $video_link);
	}


	public function is_secured_nonce($action, $nonce_field, $post_id) {
		$nonce = isset($_POST[$nonce_field]) ? $_POST[$nonce_field] : '';
		if ($nonce == '') {
			return false;
		} elseif (!wp_verify_nonce($nonce, $action)) {
			return false;
		} elseif (!current_user_can('edit_post', $post_id)) {
			return false;
		} elseif (wp_is_post_autosave($post_id)) {
			return false;
		} elseif (wp_is_post_revision($post_id)) {
			return false;
		} else {
			return true;
		}
	}
}
