<?php

namespace UltimatePostKit\Modules\ForbesTabs;

use UltimatePostKit\Base\Ultimate_Post_Kit_Module_Base;

if (!defined('ABSPATH')) {
    exit;
} // Exit if accessed directly

class Module extends Ultimate_Post_Kit_Module_Base {

    public function __construct() {
        parent::__construct();


        add_action('wp_ajax_upk_forbes_tabs', [$this, 'upk_forbes_tabs_callback']);
        add_action('wp_ajax_nopriv_upk_forbes_tabs', [$this, 'upk_forbes_tabs_callback']);
    }

    public function get_name() {
        return 'forbes-tabs';
    }

    public function get_widgets() {

        $widgets = [
            'Forbes_Tabs',
        ];

        return $widgets;
    }

    function upk_forbes_tabs_callback() {
        $settings = $_POST['settings'];
        $category = $_POST['data'];
        $showHide = $_POST['showHide'];
        $query_args = [
            'post_status'    => 'publish',
            'post_type'      => $settings['post-type'],
            'order'          => $settings['order'],
            'orderby'        => $settings['orderby'],
            'posts_per_page' => 7,
        ];
        if ($category !== '') {
            $query_args['tax_query'] = [
                [
                    'taxonomy' => $settings['taxonomy'],
                    'field'    => 'slug',
                    'terms'    => $category,
                ]
            ];
        }
        $ajaxposts = new \WP_Query($query_args);
        $response  = '';
        if ($ajaxposts->have_posts()) {
            $item_index = 1;
            while ($ajaxposts->have_posts()) :
                if ($item_index > 7) {
                    break;
                }
                $ajaxposts->the_post();
                $title                 = wp_trim_words(get_the_title(), $settings['title_text_limit'], '...');
                $post_link             = get_permalink();
                $image_src             = wp_get_attachment_image_url(get_post_thumbnail_id(), 'full');
                $category              = upk_get_category($settings['post-type']);
                $author_url            = get_author_posts_url(get_the_author_meta('ID'));
                $author_name           = get_the_author();
                $date                  = get_the_date();
                $placeholder_image_src = \Elementor\Utils::get_placeholder_image_src();
                if (empty($image_src)) {
                    $image_src = $placeholder_image_src;
                }
                $separator = $settings['meta_separator'];
                $response .= '<div class="upk-forbes-tabs-grid-item">';
                $response .= '<div class="upk-forbes-tabs-grid-item-box">';
                $response .= '<div class="upk-image-wrapper">';
                $response .= '<a href="' . esc_url($post_link) . '"><img alt="" class="upk-img" src="' . esc_url($image_src) . '"></a>';
                $response .= '</div>';
                $response .= '<div class="upk-forbes-tabs-content-box">';
                if ($showHide['show_category'] === 'yes') :
                    $response .= '<div class="upk-forbes-tabs-category">';
                    $response .= $category;
                    $response .= '</div>';
                endif;
                if ($showHide['show_title'] === 'yes') :
                    $response .= '<a class="upk-forbes-tabs-title" href="' . esc_url($post_link) . '">';
                    $response .= '<h3 class="upk-title">' . $title . '</h3>';
                    $response .= '</a>';
                endif;
                if ($showHide['show_meta'] === 'yes') :
                    $response .= '<div class="upk-blog-post-meta">';
                    if ($showHide['show_author'] === 'yes') :
                        $response .= '<div class="upk-blog-author">';
                        $response .= '<a class="author-name" href="' . $author_url . '">' . $author_name . '</a>';
                        $response .= '</div>';
                    endif;
                    $response .= '<span class="upk-separator">' . $separator . '</span>';
                    $response .= '<div class="upk-blog-date">';
                    $response .= '<span class="date">' . $date . '</span>';
                    $response .= '</div>';
                    $response .= '</div>';
                endif;
                $response .= '</div>';
                $response .= '</div>';
                $response .= '</div>';

                $item_index++;
            endwhile;
        } else {
            $response = 'empty';
        }

        echo $response;
        exit();
    }
}
