<?php
/**
 * Date calculation controller
 *
 * @package formidable-dates
 * @since 2.0
 */

/**
 * Class FrmDatesCalculationController
 */
class FrmDatesCalculationController {

	/**
	 * Adds a new setting tab for the Default value setting.
	 *
	 * @param array $types Default value setting types.
	 * @param array $atts  Field display atts.
	 * @return array
	 */
	public static function add_default_value_type( $types, $atts ) {
		if ( isset( $atts['display']['type'] ) && 'date' === $atts['display']['type'] ) {
			$types['date_calc'] = array(
				'class' => 'frm-show-inline-modal',
				'title' => __( 'Default Value (Date Calculation)', 'frmdates' ),
				'icon'  => 'frm_icon_font frm_calculator_icon',
				'data'  => array(
					'open'    => 'frm-date-calc-box-',
					'frmshow' => '.frm-date-calc-box-',
					'frmhide' => '.frm-inline-modal,.default-value-section-' . $atts['display']['field_data']->id . ',.frm-lookup-box-',
				),
			);
		}

		return $types;
	}

	/**
	 * Adds default value type box.
	 *
	 * @param array $args Includes 'field', 'display', 'default_value_types'.
	 */
	public static function add_default_value_type_box( $args ) {
		if ( ! isset( $args['field']['type'] ) || 'date' !== $args['field']['type'] ) {
			return;
		}

		$field               = $args['field'];
		$default_value_types = $args['default_value_types'];

		if ( ! empty( $args['display']['date_calc'] ) ) {
			include FrmDatesAppHelper::get_path( '/views/calc-settings.php' );
		}
	}
}
